/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.logon.LogonEvent;
import com.ibm.hwmca.fw.logon.LogonListener;
import com.ibm.hwmca.fw.logon.LogonManager;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.managed.UserProperties;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.PropertyNames;
import com.ibm.hwmca.fw.ui.UIException;
import com.ibm.hwmca.fw.ui.UIHwmcaObject;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIListenerData;
import com.ibm.hwmca.fw.ui.UIManagedObject;
import com.ibm.hwmca.fw.ui.UIManagedObjectGroup;
import com.ibm.hwmca.fw.ui.UIPropertyChangeEvent;
import com.ibm.hwmca.fw.ui.UIRequests;
import com.ibm.hwmca.fw.ui.UIResponses;
import com.ibm.hwmca.fw.ui.UITask;
import com.ibm.hwmca.fw.ui.UITaskGroup;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UITasklet
extends Tasklet
implements UIRequests,
UIResponses,
PropertyChangeListener,
LogonListener,
UserProperties {
    private static final int ACTION_CONTINUE_WAITING = 1;
    private static final int ACTION_PROPERTY_CHANGE = 2;
    private static final int ACTION_LOGOFF = 3;
    private ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private int action;
    private ClassId[] validClassIds;
    private Map propertyNamesMap = new HashMap();
    private ArrayList responseData = new ArrayList();
    private boolean listening = false;
    private Object waitingLock = new Object();
    private Object responseDataLock = new Object();
    private boolean loggedOn = true;
    private static final String TRACE_MASKT = "HUITL MT";
    private static final String TRACE_MASKF = "HUITL MF";
    private static final String TRACE_MASKD = "HUITL MD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$User;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$TaskGroup;

    public void init(Object obj) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UITasklet.init()");
        LogonManager.getLogonManager().addLogonListener(this);
        User.getUser().addPropertyChangeListener("UserSettings", this);
        Trace.trace(TRACE_MASKT, "<- UITasklet.init()");
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UITasklet.service()");
        if (request.isInitialRequest()) {
            response.noAction();
        } else {
            try {
                String requestType = (String)request.getData("Request");
                if (requestType.equals("GetUpdates")) {
                    this.serviceGetUpdatesRequest(response);
                } else if (requestType.equals("StartListening")) {
                    this.serviceStartListeningRequest(request, response);
                } else if (requestType.equals("ListenerData")) {
                    this.serviceListenerData((UIListenerData)request.getData("ListenerData"), response);
                } else if (requestType.equals("UserSettings")) {
                    this.serviceUserSettings(response);
                }
            }
            catch (UIException uIException) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "<- UITasklet.service()");
    }

    private void serviceListenerData(UIListenerData data, TaskletResponse response) throws UIException {
        Trace.trace(TRACE_MASKF, "-> UITasklet.serviceListenerData()");
        String[] classNames = data.getFullClassNames();
        this.validClassIds = new ClassId[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            Trace.trace(TRACE_MASKF, "   UI wants class [" + classNames[i] + "]");
            this.validClassIds[i] = new ClassId(classNames[i]);
        }
        PropertyNames[] propertyNames = data.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            this.propertyNamesMap.put(new ClassId(propertyNames[i].getFullClassName()), propertyNames[i].getPropertyNames());
            String s = propertyNames[i].getFullClassName();
            String[] names = propertyNames[i].getPropertyNames();
            for (int j = 0; j < names.length; ++j) {
                Trace.trace(TRACE_MASKF, "   UI wants property changes for [" + names[j] + "] in class [" + s + "]");
            }
        }
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UITasklet.serviceListenerData()");
    }

    private void serviceUserSettings(TaskletResponse response) throws UIException {
        Trace.trace(TRACE_MASKF, "-> UITasklet.serviceUserSettings()");
        response.setData("UserSettings", User.getUser().getAllUserSettings());
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UITasklet.serviceUserSettings()");
    }

    private void serviceGetUpdatesRequest(TaskletResponse response) throws UIException {
        Trace.trace(TRACE_MASKT, "-> UITasklet.serviceGetUpdatesRequest()");
        if (!this.listening) {
            throw new UIException(0);
        }
        this.waitForResponse();
        this.sendResponse(response);
        Trace.trace(TRACE_MASKF, "<- UITasklet.serviceGetUpdatesRequest()");
    }

    private void serviceStartListeningRequest(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UITasklet.serviceStartListeningRequest()");
        this.listening = true;
        this.mom.addPropertyChangeListener((PropertyChangeListener)this, true, this.validClassIds);
        this.waitForResponse();
        this.sendResponse(response);
        Trace.trace(TRACE_MASKF, "<- UITasklet.serviceStartListeningRequest()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse() {
        Trace.trace(TRACE_MASKF, "-> UITasklet.waitForResponse()");
        int numResponseData = 0;
        Object object = this.responseDataLock;
        synchronized (object) {
            numResponseData = this.responseData.size();
            Trace.trace(TRACE_MASKD, "   number of queued events is " + numResponseData);
        }
        object = this.waitingLock;
        synchronized (object) {
            if (numResponseData == 0) {
                this.action = 1;
                while (this.action == 1) {
                    try {
                        Trace.trace(TRACE_MASKF, "   waiting...");
                        this.waitingLock.wait();
                        Trace.trace(TRACE_MASKD, "   waitForResponse() woke up, action is " + this.action);
                    }
                    catch (InterruptedException exc) {
                        Trace.trace(TRACE_MASKD, "  waitForRespone() was interrupted");
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- UITasklet.waitForResponse()");
    }

    private void sendResponse(TaskletResponse response) {
        Trace.trace(TRACE_MASKF, "-> UITasklet.sendResponse()");
        if (this.loggedOn) {
            ArrayList list = this.getPropertyChanges();
            response.setData("PropertyChange", list);
        } else {
            response.setData("Logoff", "");
        }
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UITasklet.sendResponse()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getPropertyChanges() {
        Trace.trace(TRACE_MASKF, "-> UITasklet.getPropertyChanges()");
        ArrayList<UIPropertyChangeEvent> result = new ArrayList<UIPropertyChangeEvent>();
        ArrayList responseDataCopy = null;
        Object object = this.responseDataLock;
        synchronized (object) {
            responseDataCopy = (ArrayList)this.responseData.clone();
            this.responseData.clear();
        }
        Iterator iterator = responseDataCopy.iterator();
        while (iterator.hasNext()) {
            PropertyChangeEvent next = (PropertyChangeEvent)iterator.next();
            ObjectId source = (ObjectId)next.getSource();
            if (source.isInstanceOf(class$com$ibm$hwmca$fw$managed$User == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.User") : class$com$ibm$hwmca$fw$managed$User)) {
                result.add(new UIPropertyChangeEvent(source, next.getPropertyName(), next.getOldValue(), next.getNewValue()));
                continue;
            }
            if (source.isInstanceOf(class$com$ibm$hwmca$fw$managed$HwmcaObject == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.HwmcaObject") : class$com$ibm$hwmca$fw$managed$HwmcaObject)) {
                result.add(new UIPropertyChangeEvent(source, next.getPropertyName(), next.getOldValue(), next.getNewValue()));
                continue;
            }
            ObjectId[] value = (ObjectId[])next.getNewValue();
            if (value != null) {
                this.processHwmcaObjectListeners(value, true);
                result.add(new UIPropertyChangeEvent(source, next.getPropertyName(), null, this.createUIHwmcaObjects(value, true)));
                continue;
            }
            value = (ObjectId[])next.getOldValue();
            this.processHwmcaObjectListeners(value, false);
            result.add(new UIPropertyChangeEvent(source, next.getPropertyName(), this.createUIHwmcaObjects(value, false), null));
        }
        Trace.trace(TRACE_MASKD, "   number events to send to the client " + result.size());
        Trace.trace(TRACE_MASKF, "<- UITasklet.getPropertyChanges()");
        return result;
    }

    private void processHwmcaObjectListeners(ObjectId[] objectIds, boolean add) {
        Trace.trace(TRACE_MASKD, "-> UITasklet.processHwmcaObjectListeners()");
        for (int i = 0; i < objectIds.length; ++i) {
            this.processHwmcaObjectListener(objectIds[i], add);
        }
        Trace.trace(TRACE_MASKD, "<- UITasklet.processHwmcaObjectListeners()");
    }

    private void processHwmcaObjectListener(ObjectId objectId, boolean add) {
        Trace.trace(TRACE_MASKF, "-> UITasklet.processHwmcaObjectListener()");
        if (objectId == null) {
            Trace.trace(TRACE_MASKD, "   error, got a NULL ObjectId from a MOM PropertyChangeEvent");
        } else {
            ClassId objectClassId = objectId.getClassId();
            Iterator iterator = this.propertyNamesMap.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    String[] names;
                    ClassId key = (ClassId)iterator.next();
                    String keyClassName = key.getFullClassName();
                    if (!objectClassId.isInstanceOf(keyClassName) || (names = (String[])this.propertyNamesMap.get(key)) == null || names.length <= 0) continue;
                    for (int i = 0; i < names.length; ++i) {
                        if (add) {
                            this.mom.addPropertyChangeListener(objectId, names[i], this, false);
                            continue;
                        }
                        this.mom.removePropertyChangeListener(objectId, names[i], this);
                    }
                }
                catch (HException exc) {
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- UITasklet.processHwmcaObjectListener()");
    }

    private UIHwmcaObject[] createUIHwmcaObjects(ObjectId[] objectIds, boolean add) {
        Trace.trace(TRACE_MASKF, "-> UITasklet.createUIHwmcaObjects()");
        ArrayList<UIHwmcaObject> uiObjects = new ArrayList<UIHwmcaObject>();
        for (int i = 0; i < objectIds.length; ++i) {
            Trace.trace(TRACE_MASKF, "   get properties for objectid " + objectIds[i]);
            String[] names = null;
            Iterator iterator = this.propertyNamesMap.keySet().iterator();
            while (iterator.hasNext() && names == null) {
                ClassId next = (ClassId)iterator.next();
                try {
                    if (!objectIds[i].getClassId().isInstanceOf(next.getFullClassName())) continue;
                    names = (String[])this.propertyNamesMap.get(next);
                }
                catch (HException exc) {}
            }
            if (names != null && names.length > 0) {
                if (add) {
                    Map map = this.mom.getProperties(objectIds[i], names);
                    if (map == null) {
                        Trace.trace(TRACE_MASKF, "   error, 'mom.getProperties()' returned a null Map");
                        continue;
                    }
                    if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.ManagedObject") : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                        UIManagedObject uimo = new UIManagedObject(objectIds[i], (UIInfo)map.get("UIInfo"), (Set)map.get("AcceptableStatus"), (Status)map.get("Status"), (Boolean)map.get("Busy"));
                        this.addChildren(uimo, objectIds[i], (List)map.get("Children"));
                        uiObjects.add(uimo);
                        continue;
                    }
                    if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                        UIManagedObjectGroup uimog = new UIManagedObjectGroup(objectIds[i], (UIInfo)map.get("UIInfo"), (Boolean)map.get("Root"), (Boolean)map.get("StatusAcceptable"));
                        this.addChildren(uimog, objectIds[i], (List)map.get("Children"));
                        uiObjects.add(uimog);
                        continue;
                    }
                    if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$Task == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.Task") : class$com$ibm$hwmca$fw$managed$Task)) {
                        UITask uit = new UITask(objectIds[i], (UIInfo)map.get("UIInfo"), (String)map.get("PresentationTaskClassName"), (Set)map.get("PermittedObjects"), (Boolean)map.get("AnyPermitted"), (Boolean)map.get("TargetRequired"));
                        uiObjects.add(uit);
                        continue;
                    }
                    if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$TaskGroup == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.TaskGroup") : class$com$ibm$hwmca$fw$managed$TaskGroup)) {
                        UITaskGroup uitg = new UITaskGroup(objectIds[i], (UIInfo)map.get("UIInfo"), (Boolean)map.get("Root"));
                        this.addChildren(uitg, objectIds[i], (List)map.get("Children"));
                        uiObjects.add(uitg);
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "   objectid is not an instance of anything I care about, objectid is " + objectIds[i]);
                    continue;
                }
                if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.ManagedObject") : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                    UIManagedObject uimo = new UIManagedObject(objectIds[i], null, null, null, false);
                    uiObjects.add(uimo);
                    continue;
                }
                if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                    UIManagedObjectGroup uimog = new UIManagedObjectGroup(objectIds[i], null, false, false);
                    uiObjects.add(uimog);
                    continue;
                }
                if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$Task == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.Task") : class$com$ibm$hwmca$fw$managed$Task)) {
                    UITask uit = new UITask(objectIds[i], null, null, null, false, false);
                    uiObjects.add(uit);
                    continue;
                }
                if (objectIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$TaskGroup == null ? UITasklet.class$("com.ibm.hwmca.fw.managed.TaskGroup") : class$com$ibm$hwmca$fw$managed$TaskGroup)) {
                    UITaskGroup uitg = new UITaskGroup(objectIds[i], null, false);
                    uiObjects.add(uitg);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "   objectid is not an instance of anything I care about, objectid is " + objectIds[i]);
                continue;
            }
            Trace.trace(TRACE_MASKF, "   could not find property names for objectid " + objectIds[i]);
        }
        int size = uiObjects.size();
        UIHwmcaObject[] result = new UIHwmcaObject[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (UIHwmcaObject)uiObjects.get(i);
        }
        Trace.trace(TRACE_MASKF, "<- UITasklet.createUIHwmcaObjects()");
        return result;
    }

    private void addChildren(UIHwmcaObject uiObject, ObjectId object, List children) {
        ObjectId[] ids = null;
        if (children == null) {
            ids = new ObjectId[]{};
            Trace.trace(TRACE_MASKF, "   there are no children for objectid " + object);
        } else {
            int size = children.size();
            ids = new ObjectId[size];
            for (int i = 0; i < size; ++i) {
                ids[i] = (ObjectId)children.get(i);
            }
        }
        uiObject.addChildren(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> UITasklet.propertyChange()");
        Trace.trace(TRACE_MASKD, "   source is " + evt.getSource());
        Trace.trace(TRACE_MASKD, "   property name is " + evt.getPropertyName());
        if (evt.getOldValue() == null) {
            Trace.trace(TRACE_MASKD, "   oldValue is null");
        }
        if (evt.getNewValue() == null) {
            Trace.trace(TRACE_MASKD, "   newValue is null");
        }
        if (evt.getNewValue() != null && evt.getSource().equals(this.mom.getObjectId())) {
            Trace.trace(TRACE_MASKD, "   objectIds from MOM are: ");
            ObjectId[] ids = (ObjectId[])evt.getNewValue();
            for (int i = 0; i < ids.length; ++i) {
                Trace.trace(TRACE_MASKD, ids[i]);
            }
        }
        Object object = this.responseDataLock;
        synchronized (object) {
            this.responseData.add(evt);
            Trace.trace(TRACE_MASKD, "   added event, number of events queued is " + this.responseData.size());
        }
        object = this.waitingLock;
        synchronized (object) {
            this.action = 2;
            Trace.trace(TRACE_MASKD, "   wake up and send the event");
            this.waitingLock.notify();
        }
        Trace.trace(TRACE_MASKT, "<- UITasklet.propertyChange()");
    }

    public void loggedOn(LogonEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loggedOff(LogonEvent evt) {
        Trace.trace(TRACE_MASKF, "-> UITasklet.loggedOff()");
        this.loggedOn = false;
        this.removeAllListeners();
        this.action = 3;
        Object object = this.waitingLock;
        synchronized (object) {
            this.waitingLock.notify();
        }
        Trace.trace(TRACE_MASKF, "<- UITasklet.loggedOff()");
    }

    public void disconnected(LogonEvent event) {
    }

    public void reconnected(LogonEvent event) {
    }

    private void removeAllListeners() {
        if (this.mom != null) {
            this.mom.removePropertyChangeListener(this);
            Set inventory = this.mom.getInventoryObjectIds(this.validClassIds);
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                ObjectId next = (ObjectId)iterator.next();
                this.processHwmcaObjectListener(next, false);
            }
        }
        LogonManager.getLogonManager().removeLogonListener(this);
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "Error in UITasklet.logException(): " + throwable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

